
unit QueryCustomer;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnSubmit_Click(sender: System.Object; e: System.EventArgs);
    procedure calStartDate_SelectionChanged(sender: System.Object; e: System.EventArgs);
    procedure calEndDate_SelectionChanged(sender: System.Object; e: System.EventArgs);
    procedure txtStartDate_TextChanged(sender: System.Object; e: System.EventArgs);
    procedure txtEndDate_TextChanged(sender: System.Object; e: System.EventArgs);
    procedure calStartDate_Load(sender: System.Object; e: System.EventArgs);
    procedure calEndDate_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    calEndDate: System.Web.UI.WebControls.Calendar;
    Label1: System.Web.UI.WebControls.Label;
    Label2: System.Web.UI.WebControls.Label;
    calStartDate: System.Web.UI.WebControls.Calendar;
    btnSubmit: System.Web.UI.WebControls.Button;
    btnCancel: System.Web.UI.WebControls.Button;
    txtStartDate: System.Web.UI.WebControls.TextBox;
    txtEndDate: System.Web.UI.WebControls.TextBox;
    CompareValidator1: System.Web.UI.WebControls.CompareValidator;
    rgExpValStartDate: System.Web.UI.WebControls.RegularExpressionValidator;
    rgExpValEndDate: System.Web.UI.WebControls.RegularExpressionValidator;
    CompareValidator2: System.Web.UI.WebControls.CompareValidator;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
begin
  Include(Self.calEndDate.Load, Self.calEndDate_Load);
  Include(Self.calEndDate.SelectionChanged, Self.calEndDate_SelectionChanged);
  Include(Self.calStartDate.Load, Self.calStartDate_Load);
  Include(Self.calStartDate.SelectionChanged, Self.calStartDate_SelectionChanged);
  Include(Self.btnSubmit.Click, Self.btnSubmit_Click);
  Include(Self.txtStartDate.TextChanged, Self.txtStartDate_TextChanged);
  Include(Self.txtEndDate.TextChanged, Self.txtEndDate_TextChanged);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.calEndDate_Load(sender: System.Object; e: System.EventArgs);
begin
  if not IsPostBack then
  begin
    if Cache['enddate'] <> nil then
      calEndDate.SelectedDate := Convert.ToDateTime(Cache['enddate'])
    else
      calEndDate.SelectedDate := DateTime.Today;
    calEndDate.VisibleDate := calEndDate.SelectedDate;
    txtEndDate.Text := calEndDate.SelectedDate.ToShortDateString;
  end
end;

procedure TWebForm1.calStartDate_Load(sender: System.Object; e: System.EventArgs);
begin
  if not IsPostBack then
  begin
    if Cache['startdate'] <> nil then
      calStartDate.SelectedDate := Convert.ToDateTime(Cache['startdate'])
    else
      calStartDate.SelectedDate := DateTime.Today;
    calStartDate.VisibleDate := calStartDate.SelectedDate;
    txtStartDate.Text := calStartDate.SelectedDate.ToShortDateString;
  end
end;

procedure TWebForm1.txtStartDate_TextChanged(sender: System.Object; e: System.EventArgs);
begin
  try
    if not txtStartDate.Text.Equals(calStartDate.SelectedDate.ToShortDateString) then
    begin
      calStartDate.SelectedDate := Convert.ToDateTime(txtStartDate.Text);
      calStartDate.VisibleDate := calStartDate.SelectedDate;
    end
  except
  end;
end;

procedure TWebForm1.calStartDate_SelectionChanged(sender: System.Object; e: System.EventArgs);
begin
  if not calStartDate.SelectedDate.ToShortDateString.Equals(txtStartDate.Text) then
    txtStartDate.Text := calStartDate.SelectedDate.ToShortDateString;
end;

procedure TWebForm1.txtEndDate_TextChanged(sender: System.Object; e: System.EventArgs);
begin
  try
    if not txtEndDate.Text.Equals(calEndDate.SelectedDate.ToShortDateString) then
    begin
      calEndDate.SelectedDate := Convert.ToDateTime(txtEndDate.Text);
      calEndDate.VisibleDate := calEndDate.SelectedDate;
    end
  except
  end;
end;

procedure TWebForm1.calEndDate_SelectionChanged(sender: System.Object; e: System.EventArgs);
begin
  if not calEndDate.SelectedDate.ToShortDateString.Equals(txtEndDate.Text) then
    txtEndDate.Text := calEndDate.SelectedDate.ToShortDateString;
end;

procedure TWebForm1.btnSubmit_Click(sender: System.Object; e: System.EventArgs);
begin
  Cache['startdate'] := calStartDate.SelectedDate.ToShortDateString;
  Cache['enddate'] := calEndDate.SelectedDate.ToShortDateString;
  Response.Redirect('BrowseOrders.aspx');
end;

end.

